//+------------------------------------------------------------------+
//|                                      Check_FileFunctions.dll.mq5 |
//|                                      Copyright  Zhunko          |
//| 12.02.2014 - 28.02.2014              vadim@zhunko.ru             |
//+------------------------------------------------------------------+
//|        Windows Vista  .|
//+------------------------------------------------------------------+
#property copyright   "Copyright  Zhunko"
#property link        "vadim@zhunko.ru"
#property description "       \"FileFunctions.dll\"."
#property strict
#property show_inputs

#include <FileFunctions.mqh> //    "FileFunctions.dll"     .
//
input bool   AllTest              = false; //    .
input string _1_____Common_Operations______1_ = "_1_______Common_Operations________1_"; // 1.          .
input string FilePathSource       = "";    //        .
input string FilePathDest         = "";    //      .
input bool   Check                = false; // 1.1.     : FileCheckW().
input bool   Copy                 = false; // 1.2.     : FileCopyW().
input bool   Delete               = false; // 1.3.    : FileDeleteW().
input bool   HardLink             = false; // 1.4.        : FileHardLinkW().
input bool   Move                 = false; // 1.5.    ()  : FileMoveW().
input bool   SymbolicLink         = false; // 1.6.        : FileSymbolicLinkW().
input string _2______OperationsByHandle______2_ = "_2_______OperationsByHandle________2_"; // 2.         .
input bool   Clear                = false; // 2.1.      .
input bool   CloseHandle          = false; // 2.2.      .
input bool   CopyByHandle         = false; // 2.3.    .
input bool   DeleteByHandle       = false; // 2.4.    .
input bool   FlushApply           = false; // 2.5.           .
input bool   GetSize              = false; // 2.6.     .
input bool   HardLinkByHandle     = false; // 2.7.        .
input bool   MoveByHandle         = false; // 2.8.    () .
input bool   Resize               = false; // 2.9.     .
input bool   SymbolicLinkByHandle = false; // 2.10.       .
input string _3________WRITE_READ________3_ = "_3_________WRITE_READ__________3_"; // 3.  /.
input bool   POINTER              = false; // 4.      .
input bool   WRITE                = false; // 5-6.  .
input bool   READ                 = false; // 7-8.  .
//
void OnStart()
 {
  bool   bResult = false; //   .
  int    i = 0;
  int    hFile = 0;
  int    nSize = 0;       //  .
  string sComment = "";
  string sDate = TimeToString(TimeLocal(), TIME_DATE);                         //       LOG-.
  StringReplace(sDate, ".", "");                                               //    .
  string sFilePathSource = TerminalPath() + "\\MQL4\\Logs\\" + sDate + ".log"; //        .
  string sPathDest1 = TerminalPath() + "\\Test1\\";                            //   1      .
  string sPathDest2 = TerminalPath() + "\\Test2\\";                            //   2      .
  string sFilePathDest1 = sPathDest1 + "Text1.txt";                            //   1      .
  string sFilePathDest2 = sPathDest2 + "Text2.txt";                            //   2      .
  //  .
  uchar  szWriteAnsi[] = {0};
  string sWriteUnicode = " !";
  bool   abWrite[10] = {true, false, true, false, true, true, true, false, false, false};
  char   acWrite[10] = {-128, -93, -70, -25, 0, 25, 56, 86, 96, 127};
  uchar  aucWrite[10] = {255, 230, 210, 199, 175, 150, 123, 75, 54, 0};
  short  ashWrite[10] = {-32768, -22210, -16789, -8765, 0, 4567, 8907, 16789, 22456, 32767};
  ushort aushWrite[10] = {65535, 45456, 35789, 18907, 12567, 50764, 4765, 3789, 1210, 0};
  int    aiWrite[10] = {-2147483648, -1147432001, -16789, -8765, 0, 4567, 8907, 16789, 1147432001, 2147483647};
  uint   auiWrite[10] = {4294967295, 2147483647, 1147432001, 2600535, 130535, 65535, 16789, 8907, 4567, 0};
  long   alWrite[10] = {-9223372036854775808, -4294967295, -16789, -8765, 0, 4567, 8907, 16789, 4294967295, 9223372036854775807};
  ulong  aulWrite[10] = {18446744073709551615, 9223372036854775807, 8294967295, 4294967295, 2147483647, 1147432001, 16789, 8907, 4567, 0};
  float  afWrite[10] = {-21474.32f, -11474.32f, -16.7891f, -876.5123f, 0, 45671.23f, 890712.34f, 167891.23f, 1147432.001f, 214743.2001f};
  double adWrite[10] = {-21474.3200112345, -11474.3200112345, -16.78912345, -876.512345, 0, 45671.2345612345, 890712.345678912, 167891.234567891, 1147432.00112345, 214743.200112345};
  string asWrite[10] = {"Hello world!", "", "", "", "", "", "Test1.txt", " ", " ", "."};
  //  .
  uchar  szReadAnsi[12] = {0}; //      ANSI-.
  string sReadUnicode;
  bool   abRead[10] = {0};
  char   acRead[10] = {0};
  uchar  aucRead[10] = {0};
  short  ashRead[10] = {0};
  ushort aushRead[10] = {0};
  int    aiRead[10] = {0};
  uint   auiRead[10] = {0};
  long   alRead[10] = {0};
  ulong  aulRead[10] = {0};
  float  afRead[10] = {0};
  double adRead[10] = {0};
  string asRead[10];
  //
  //     .
  if (FilePathSource != "") sFilePathSource = FilePathSource;
  if (FilePathDest != "") sFilePathDest1 = FilePathDest;
  StringToCharArray(sWriteUnicode, szWriteAnsi); //  ANSI-.
//  for (i = 0; i < ArraySize(asWrite); i++) asWrite[i] = StringConcatenate(i + 1, " x ", i + 1, " = ", (i + 1) * (i + 1));
  for (i = 0; i < ArraySize(asRead); i++) asRead[i] = string(i) + "               "; //   .
  //
  // 1.     .
  //
  // 1.1.    .   ,   TRUE,  - FALSE.
  if (AllTest || Check || Copy)
   {
    sComment = StringConcatenate(sComment, "1.1.      .\n");
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    BOOL bFileCheck = FileCheckW(sFilePathSource);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathSource, "\") = ", bFileCheck, "\n");
    Comment(sComment);
    if (bFileCheck == 0) Alert(",     .");
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathDest1, "\") = ", FileCheckW(sFilePathDest1), "\n\n");
    Comment(sComment);
    Sleep(30000);
   }
  //=====================================================================================================================================================================
  // 1.2.    .   ,    .     .
  //         ,   TRUE,  - FALSE.
  //           .
  if (AllTest || Copy)
   {
    sComment = StringConcatenate(sComment, "1.2.   : ", FileCopyW(sFilePathSource, sFilePathDest1), "\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathSource, "\") = ", FileCheckW(sFilePathSource), "\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathDest1, "\") = ", FileCheckW(sFilePathDest1), "\n\n");
    Comment(sComment);
    Sleep(30000);
   }
  //=====================================================================================================================================================================
  // 1.3.   .   ,   TRUE,  - FALSE.
  if (AllTest || Delete || Copy)
   {
    sComment = StringConcatenate(sComment, "1.3.   .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileDeleteW(\"", sFilePathDest1, "\") = ", FileDeleteW(sFilePathDest1), "\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathDest1, "\") = ", FileCheckW(sFilePathDest1), "\n\n");
    Comment(sComment);
    Sleep(30000);
   }
  //=====================================================================================================================================================================
  // 1.4.       .    ,   TRUE,  - FALSE.
  //           .
  if (AllTest || HardLink)
   {
    sComment = StringConcatenate(sComment, "1.4.      .\n");
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathDest1, "\") = ", FileCheckW(sFilePathDest1), "\n");
    Comment(sComment);
    FileHardLinkW(sFilePathSource, sFilePathDest1);
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathDest1, "\") = ", FileCheckW(sFilePathDest1), "\n\n");
    Comment(sComment);
    Sleep(30000);
    FileDeleteW(sPathDest1); //    .
   }
  //=====================================================================================================================================================================
  // 1.5.   ()  .   ,      .
  //         ,   TRUE,  - FALSE.
  //           .
  if (AllTest || Move)
   {
    sComment = StringConcatenate(sComment, "1.5.   .\n");
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathDest1, "\") = ", FileCheckW(sFilePathDest1), "\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        : ", FileMoveW(sFilePathSource, sFilePathDest1), "\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathDest1, "\") = ", FileCheckW(sFilePathDest1), "\n\n");
    Comment(sComment);
    Sleep(30000);
    sComment = StringConcatenate(sComment, "          .\n");
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathSource, "\") = ", FileCheckW(sFilePathSource), "\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        : ", FileMoveW(sFilePathDest1, sFilePathSource), "\n"); //  .
    Comment(sComment);
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathSource, "\") = ", FileCheckW(sFilePathSource), "\n\n");
    Comment(sComment);
    Sleep(30000);
   }
  //=====================================================================================================================================================================
  // 1.6.       .    ,   TRUE,  - FALSE.
  //           .
  if (AllTest || SymbolicLink)
   {
    sComment = StringConcatenate(sComment, "1.6.      .\n");
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathDest1, "\") = ", FileCheckW(sFilePathDest1), "\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileSymbolicLinkW() = ", FileSymbolicLinkW(sFilePathSource, sFilePathDest1), "\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathDest1, "\") = ", FileCheckW(sFilePathDest1), "\n\n");
    Comment(sComment);
    Sleep(30000);
    FileDeleteW(sPathDest1); //    .
   }
  //
  // 2.         .
  //
  if (AllTest || Clear || CloseHandle || CopyByHandle || DeleteByHandle || FlushApply || GetSize || HardLinkByHandle || MoveByHandle || Resize || SymbolicLinkByHandle)
   {//===================================================================================================================================================================
    sComment = StringConcatenate(sComment, "1.2.   : ", FileCopyW(sFilePathSource, sFilePathDest1), "\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathSource, "\") = ", FileCheckW(sFilePathSource), "\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathDest1, "\") = ", FileCheckW(sFilePathDest1), "\n");
    Comment(sComment);
    Sleep(15000);
    //===================================================================================================================================================================
    // 2.2.4.    ,   .         ,  - NULL.
    sComment = StringConcatenate(sComment, "3.4.   ,   .\n");
    Comment(sComment);
    hFile = FileOpenExistingW(sFilePathDest1, GENERIC_ALL, SHARE_DELETE|SHARE_READ|SHARE_WRITE);
    sComment = StringConcatenate(sComment, "          : ", hFile, "\n\n");
    Comment(sComment);
    Sleep(15000);
    //===================================================================================================================================================================
   }
  //
  if (AllTest || GetSize || Clear || Resize || FlushApply)
   {//===================================================================================================================================================================
    // 2.6.    .
    sComment = StringConcatenate(sComment, "2.6.   : ", FileGetSize(hFile), ".\n");
    Comment(sComment);
    //===================================================================================================================================================================
    // 2.1.     .
    sComment = StringConcatenate(sComment, "2.1.     .\n");
    Comment(sComment);
    FileClear(hFile);
    //===================================================================================================================================================================
    // 2.6.    .
    sComment = StringConcatenate(sComment, "2.6.   : ", FileGetSize(hFile), " (0 ).\n");
    Comment(sComment);
    //===================================================================================================================================================================
    // 2.9.    .
    sComment = StringConcatenate(sComment, "2.9.     (10000 ).\n");
    Comment(sComment);
    FileResize(hFile, 10000);
    //===================================================================================================================================================================
    // 2.6.    .
    sComment = StringConcatenate(sComment, "2.6.   : ", FileGetSize(hFile), " (10000 ).\n");
    Comment(sComment);
    //===================================================================================================================================================================
    // 2.5.                .
    sComment = StringConcatenate(sComment, "2.5.             .\n\n");
    Comment(sComment);
    FileFlushApply(hFile);
    //===================================================================================================================================================================
   }
  //
  if (AllTest || CopyByHandle)
   {//===================================================================================================================================================================
    // 2.3.   .   ,    .     .
    //             ,    .
    sComment = StringConcatenate(sComment, "2.3.   : ");
    Comment(sComment);
    sComment = StringConcatenate(sComment, FileCopyByHandleW(hFile, sFilePathDest2), "\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathDest1, "\") = ", FileCheckW(sFilePathDest1), "\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathDest2, "\") = ", FileCheckW(sFilePathDest2), "\n\n");
    Comment(sComment);
    Sleep(30000);
    sComment = StringConcatenate(sComment, "            .\n\n");
    FileDeleteW(sFilePathDest2); //   .
   }
  //=====================================================================================================================================================================
  // 2.7.       .
  if (AllTest || HardLinkByHandle)
   {
    sComment = StringConcatenate(sComment, "2.7.      .\n");
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathDest2, "\") = ", FileCheckW(sFilePathDest2), "\n");
    Comment(sComment);
    FileHardLinkByHandleW(hFile, sFilePathDest2);
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathDest2, "\") = ", FileCheckW(sFilePathDest2), "\n\n");
    Comment(sComment);
    Sleep(30000);
    FileDeleteW(sFilePathDest2); //  .
   }
  //=====================================================================================================================================================================
  // 2.8.       .
  if (AllTest || MoveByHandle)
   {
    sComment = StringConcatenate(sComment, "1.8.   .\n");
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathDest2, "\") = ", FileCheckW(sFilePathDest2), "\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        : ", FileMoveByHandleW(hFile, sFilePathDest2), "\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "         .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathDest2, "\") = ", FileCheckW(sFilePathDest2), "\n\n");
    Comment(sComment);
    Sleep(30000);
    FileDeleteW(sFilePathDest2); //  .
   }
  //=====================================================================================================================================================================
  // 2.10.       .    ,   TRUE,  - FALSE.
  if (AllTest || SymbolicLink)
   {
    sComment = StringConcatenate(sComment, "2.10.      .\n");
    sComment = StringConcatenate(sComment, "          .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "         FileCheckW(\"", sFilePathDest2, "\") = ", FileCheckW(sFilePathDest2), "\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "         FileMoveW() = ", FileSymbolicLinkByHandleW(hFile, sFilePathDest2), "\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "          .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "         FileCheckW(\"", sFilePathDest2, "\") = ", FileCheckW(sFilePathDest2), "\n\n");
    Comment(sComment);
    Sleep(30000);
    FileDeleteW(sFilePathDest2); //  .
   }
  if (AllTest || Clear || CloseHandle || CopyByHandle || DeleteByHandle || FlushApply || GetSize || HardLinkByHandle || MoveByHandle || Resize || SymbolicLinkByHandle)
   {//===================================================================================================================================================================
    // 2.4.   .
    if (DeleteByHandle && !CloseHandle)
     {
      sComment = StringConcatenate(sComment, "2.4.       .\n");
      Comment(sComment);
      sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathDest1, "\") = ", FileCheckW(sFilePathDest1), "\n\n");
      Comment(sComment);
      FileDeleteByHandle(hFile);
     }
    else
    //===================================================================================================================================================================
    // 2.2.     .
    if (!DeleteByHandle && CloseHandle)
     {
      sComment = StringConcatenate(sComment, "2.2.     (", hFile, ").\n\n");
      Comment(sComment);
      FileCloseHandle(hFile);
     }
    else
    //===================================================================================================================================================================
    // 2.4.   .
    if (AllTest || Clear || CopyByHandle || FlushApply || GetSize || HardLinkByHandle || Resize || SymbolicLinkByHandle)
     {
      sComment = StringConcatenate(sComment, "2.4.       .\n");
      Comment(sComment);
      sComment = StringConcatenate(sComment, "        FileCheckW(\"", sFilePathDest1, "\") = ", FileCheckW(sFilePathDest1), "\n\n");
      Comment(sComment);
      FileDeleteByHandle(hFile);
     }
    else Alert("   . DeleteByHandle  CloseHandle     !");
   }
  //
  // 4.      .
  //
  if (AllTest || POINTER)
   {//===================================================================================================================================================================
    // 3.1.1.     .   ,   .
    //                ,  - NULL.
    sComment = StringConcatenate(sComment, "3.1.     .\n");
    Comment(sComment);
    int hFilePtr = FileCreateAlwaysW(sFilePathDest1, GENERIC_ALL, SHARE_READ|SHARE_WRITE);
    sComment = StringConcatenate(sComment, "          : ", hFilePtr, "\n\n");
    Comment(sComment);
    //===================================================================================================================================================================
    // 6.5.         INT (4 )      .
    //              ULONG_MAX.
    long ulTest = 0;
    int anArr[3] = {1, 2, 3};
    sComment = StringConcatenate(sComment, "6.5.          INT (4 )      .\n");
    Comment(sComment);
    sComment = StringConcatenate(sComment, "         : ", FileWriteIntArray(hFilePtr, anArr, ArraySize(anArr), 0, 3), "\n\n");
    Comment(sComment);
    //===================================================================================================================================================================
    // 4.2.             .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "4.2.              .\n");
    Comment(sComment);
    
    ulTest = FileSetPointerBegin(hFilePtr, 2 * sizeof(int));
    sComment = StringConcatenate(sComment, "         : ", ulTest, " (", 2 * sizeof(int), ")\n");
    Comment(sComment);
    if (ulTest != 2 * sizeof(int)) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    ulTest = FileReadInt(hFilePtr);
    sComment = StringConcatenate(sComment, "        : ", ulTest, " (3)\n");
    Comment(sComment);
    if (ulTest != 3) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    
    ulTest = FileSetPointerBegin(hFilePtr, 1 * sizeof(int));
    sComment = StringConcatenate(sComment, "         : ", ulTest, " (", 1 * sizeof(int), ")\n");
    Comment(sComment);
    if (ulTest != 1 * sizeof(int)) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    ulTest = FileReadInt(hFilePtr);
    sComment = StringConcatenate(sComment, "        : ", ulTest, " (2)\n");
    Comment(sComment);
    if (ulTest != 2) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    
    ulTest = FileSetPointerBegin(hFilePtr, 0 * sizeof(int));
    sComment = StringConcatenate(sComment, "         : ", ulTest, " (", 0 * sizeof(int), ")\n");
    Comment(sComment);
    if (ulTest != 0 * sizeof(int)) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    ulTest = FileReadInt(hFilePtr);
    sComment = StringConcatenate(sComment, "        : ", ulTest, " (1)\n\n");
    Comment(sComment);
    if (ulTest != 1) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 4.3.               .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "4.3.                .\n");
    Comment(sComment);
    
    ulTest = FileSetPointerCurrent(hFilePtr, 1 * sizeof(int));
    sComment = StringConcatenate(sComment, "         : ", ulTest, " (", 2 * sizeof(int), ")\n");
    Comment(sComment);
    if (ulTest != 2 * sizeof(int)) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    ulTest = FileReadInt(hFilePtr);
    sComment = StringConcatenate(sComment, "        : ", ulTest, " (3)\n");
    Comment(sComment);
    if (ulTest != 3) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    
    ulTest = FileSetPointerCurrent(hFilePtr, -2 * sizeof(int));
    sComment = StringConcatenate(sComment, "         : ", ulTest, " (", 1 * sizeof(int), ")\n");
    Comment(sComment);
    if (ulTest != 1 * sizeof(int)) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    ulTest = FileReadInt(hFilePtr);
    sComment = StringConcatenate(sComment, "        : ", ulTest, " (2)\n");
    Comment(sComment);
    if (ulTest != 2) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    
    ulTest = FileSetPointerCurrent(hFilePtr, -2 * sizeof(int));
    sComment = StringConcatenate(sComment, "         : ", ulTest, " (", 0 * sizeof(int), ")\n");
    Comment(sComment);
    if (ulTest != 0 * sizeof(int)) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    ulTest = FileReadInt(hFilePtr);
    sComment = StringConcatenate(sComment, "        : ", ulTest, " (1)\n\n");
    Comment(sComment);
    if (ulTest != 1) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 4.4.             .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "4.4.              .\n");
    Comment(sComment);
    
    ulTest = FileSetPointerEnd(hFilePtr, -1 * sizeof(int));
    sComment = StringConcatenate(sComment, "         : ", ulTest, " (", 2 * sizeof(int), ")\n");
    Comment(sComment);
    if (ulTest != 2 * sizeof(int)) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    ulTest = FileReadInt(hFilePtr);
    sComment = StringConcatenate(sComment, "        : ", ulTest, " (3)\n");
    Comment(sComment);
    if (ulTest != 3) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    
    ulTest = FileSetPointerEnd(hFilePtr, -2 * sizeof(int));
    sComment = StringConcatenate(sComment, "         : ", ulTest, " (", 1 * sizeof(int), ")\n");
    Comment(sComment);
    if (ulTest != 1 * sizeof(int)) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    ulTest = FileReadInt(hFilePtr);
    sComment = StringConcatenate(sComment, "        : ", ulTest, " (2)\n");
    Comment(sComment);
    if (ulTest != 2) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    
    ulTest = FileSetPointerEnd(hFilePtr, -3 * sizeof(int));
    sComment = StringConcatenate(sComment, "         : ", ulTest, " (", 0 * sizeof(int), ")\n");
    Comment(sComment);
    if (ulTest != 0 * sizeof(int)) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    ulTest = FileReadInt(hFilePtr);
    sComment = StringConcatenate(sComment, "        : ", ulTest, " (1)\n");
    Comment(sComment);
    if (ulTest != 1) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 2.4.   .
    sComment = StringConcatenate(sComment, "2.4.       .\n");
    Comment(sComment);
    FileDeleteByHandle(hFilePtr);
    //===================================================================================================================================================================
   }
  //
  // 5-6.    .
  //
  if (AllTest || WRITE)
   {
    ulong ulTest = 0;
    //===================================================================================================================================================================
    // 3.1.1.     .   ,   .
    //                ,  - NULL.
    sComment = StringConcatenate(sComment, "3.1.     .\n");
    Comment(sComment);
    int hFileWrite = FileCreateAlwaysW(sFilePathDest1, GENERIC_ALL, SHARE_READ|SHARE_WRITE);
    sComment = StringConcatenate(sComment, "          : ", hFileWrite, "\n\n");
    Comment(sComment);
    //xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
    // 5.       .
    //xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
    sComment = StringConcatenate(sComment, "5.        .\n");
    Comment(sComment);
    //===================================================================================================================================================================
    // 5.1.       BOOL (1 )     .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "5.1.       BOOL.\n");
    Comment(sComment);
    ulTest = FileWriteBoolean(hFileWrite, abWrite[0]);
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (1)\n");
    Comment(sComment);
    if (ulTest != 1) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 5.2.       CHAR (1 )     .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "5.2.       CHAR.\n");
    Comment(sComment);
    ulTest = FileWriteChar(hFileWrite, acWrite[0]);
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (1)\n");
    Comment(sComment);
    if (ulTest != 1) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 5.3.       UCHAR (1 )     .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "5.3.       UCHAR.\n");
    Comment(sComment);
    ulTest = FileWriteUChar(hFileWrite, aucWrite[0]);
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (1)\n");
    Comment(sComment);
    if (ulTest != 1) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 5.4.       SHORT (2 )     .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "5.4.       SHORT.\n");
    Comment(sComment);
    ulTest = FileWriteShort(hFileWrite, ashWrite[0]);
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (2)\n");
    Comment(sComment);
    if (ulTest != 2) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 5.5.       USHORT (2 )     .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "5.5.       USHORT.\n");
    Comment(sComment);
    ulTest = FileWriteUShort(hFileWrite, aushWrite[0]);
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (2)\n");
    Comment(sComment);
    if (ulTest != 2) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 5.6.       INT (4 )     .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "5.6.       INT.\n");
    Comment(sComment);
    ulTest = FileWriteInt(hFileWrite, aiWrite[0]);
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (4)\n");
    Comment(sComment);
    if (ulTest != 4) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 5.7.       UINT (4 )     .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "5.7.       UINT.\n");
    Comment(sComment);
    ulTest = FileWriteUInt(hFileWrite, auiWrite[0]);
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (4)\n");
    Comment(sComment);
    if (ulTest != 4) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 5.8.       INT64 (8 )     .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "5.8.       INT64.\n");
    Comment(sComment);
    ulTest = FileWriteInt64(hFileWrite, alWrite[0]);
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (8)\n");
    Comment(sComment);
    if (ulTest != 8) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 5.9.       UINT64 (8 )     .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "5.9.       UINT64.\n");
    Comment(sComment);
    ulTest = FileWriteUInt64(hFileWrite, aulWrite[0]);
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (8)\n");
    Comment(sComment);
    if (ulTest != 8) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 5.10.       FLOAT (4 )     .
    //               ULONG_MAX.
    sComment = StringConcatenate(sComment, "5.10.       FLOAT.\n");
    Comment(sComment);
    ulTest = FileWriteFlt(hFileWrite, afWrite[0]);
    sComment = StringConcatenate(sComment, "           : ", ulTest, " (4)\n");
    Comment(sComment);
    if (ulTest != 4) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 5.11.       DOUBLE (8 )     .
    //               ULONG_MAX.
    sComment = StringConcatenate(sComment, "5.11.       DOUBLE.\n");
    Comment(sComment);
    ulTest = FileWriteDbl(hFileWrite, adWrite[0]);
    sComment = StringConcatenate(sComment, "           : ", ulTest, " (8)\n");
    Comment(sComment);
    if (ulTest != 8) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 5.12.1.     ANSI-     .
    //                 ULONG_MAX.
    sComment = StringConcatenate(sComment, "5.12.1.     ANSI-.\n");
    Comment(sComment);
    ulTest = FileWriteStringA(hFileWrite, szWriteAnsi);
    sComment = StringConcatenate(sComment, "             : ", ulTest, " (11)\n");
    Comment(sComment);
    if (ulTest != 11) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //-------------------------------------------------------------------------------------------------------------------------------------------------------------------
    // 5.12.2.     UNICODE-     .
    //                 ULONG_MAX.
    sComment = StringConcatenate(sComment, "5.12.2.     UNICODE-.\n");
    Comment(sComment);
    ulTest = FileWriteStringW(hFileWrite, sWriteUnicode);
    sComment = StringConcatenate(sComment, "             : ", ulTest, " (22)\n\n");
    Comment(sComment);
    if (ulTest != 22) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
    // 6.     .
    //xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
    sComment = StringConcatenate(sComment, "6.      .\n");
    Comment(sComment);
    //===================================================================================================================================================================
    // 6.1.         BOOL (1 )      .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "6.1.         BOOL.\n");
    Comment(sComment);
    ulTest = FileWriteBoolArray(hFileWrite, abWrite, ArraySize(abWrite), 0, ArraySize(abWrite));
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 6.2.         CHAR (1 )      .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "6.2.         CHAR.\n");
    Comment(sComment);
    ulTest = FileWriteCharArray(hFileWrite, acWrite, ArraySize(acWrite), 0, ArraySize(acWrite));
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 6.3.         UCHAR (1 )      .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "6.3.         UCHAR.\n");
    Comment(sComment);
    ulTest = FileWriteUCharArray(hFileWrite, aucWrite, ArraySize(aucWrite), 0, ArraySize(aucWrite));
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 6.4.         SHORT (2 )      .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "6.4.         SHORT.\n");
    Comment(sComment);
    ulTest = FileWriteShortArray(hFileWrite, ashWrite, ArraySize(ashWrite), 0, ArraySize(ashWrite));
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 6.5.         USHORT (2 )      .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "6.4.         USHORT.\n");
    Comment(sComment);
    ulTest = FileWriteUShortArray(hFileWrite, aushWrite, ArraySize(aushWrite), 0, ArraySize(aushWrite));
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 6.6.         INT (4 )      .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "6.6.         INT.\n");
    Comment(sComment);
    ulTest = FileWriteIntArray(hFileWrite, aiWrite, ArraySize(aiWrite), 0, ArraySize(aiWrite));
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 6.7.         UINT (4 )      .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "6.7.         UINT.\n");
    Comment(sComment);
    ulTest = FileWriteUIntArray(hFileWrite, auiWrite, ArraySize(auiWrite), 0, ArraySize(auiWrite));
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 6.8.         INT64 (8 )      .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "6.8.         INT64.\n");
    Comment(sComment);
    ulTest = FileWriteLongArray(hFileWrite, alWrite, ArraySize(alWrite), 0, ArraySize(alWrite));
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 6.9.         UINT64 (8 )      .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "6.9.         UINT64.\n");
    Comment(sComment);
    ulTest = FileWriteULongArray(hFileWrite, aulWrite, ArraySize(aulWrite), 0, ArraySize(aulWrite));
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 6.10.         FLOAT (4 )      .
    //               ULONG_MAX.
    sComment = StringConcatenate(sComment, "6.10.         FLOAT.\n");
    Comment(sComment);
    ulTest = FileWriteFloatArray(hFileWrite, afWrite, ArraySize(afWrite), 0, ArraySize(afWrite));
    sComment = StringConcatenate(sComment, "           : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 6.11.         DOUBLE (8 )      .
    //               ULONG_MAX.
    sComment = StringConcatenate(sComment, "6.11.         DOUBLE.\n");
    Comment(sComment);
    ulTest = FileWriteDoubleArray(hFileWrite, adWrite, ArraySize(adWrite), 0, ArraySize(adWrite));
    sComment = StringConcatenate(sComment, "           : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 6.12.2.        MQLSTRW      .
    //           ,            ("\r\n").
    //                 ULONG_MAX.
    sComment = StringConcatenate(sComment, "6.12.2.        MQLSTRW.\n");
    Comment(sComment);
    ulTest = FileWriteStrArrayMW(hFileWrite, asWrite, ArraySize(asWrite), 0, ArraySize(asWrite));
    sComment = StringConcatenate(sComment, "             : ", ulTest, " (10)\n\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 2.2.     .
    sComment = StringConcatenate(sComment, "2.2.     (", hFileWrite, ").\n\n");
    Comment(sComment);
    FileCloseHandle(hFileWrite);
    //===================================================================================================================================================================
   }
  //
  // 7-8.    .
  //
  if (AllTest || READ)
   {//===================================================================================================================================================================
    // 3.4.2.    ,   .
    //                ,  - NULL.
    sComment = StringConcatenate(sComment, "3.4.    ,   .\n");
    Comment(sComment);
    int hFileRead = FileOpenExistingW(sFilePathDest1, GENERIC_ALL, SHARE_READ|SHARE_WRITE);
    sComment = StringConcatenate(sComment, "          : ", hFileRead, "\n\n");
    Comment(sComment);
    //xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
    // 7.       .
    //xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
    sComment = StringConcatenate(sComment, "7.        .\n");
    Comment(sComment);
    //===================================================================================================================================================================
    // 7.1.       BOOL (1 )   .         FALSE.
    sComment = StringConcatenate(sComment, "7.1.       BOOL.\n");
    Comment(sComment);
    bool bTest = FileReadBoolean(hFileRead);
    sComment = StringConcatenate(sComment, "        : ", bTest, " (", abWrite[0], ")\n");
    Comment(sComment);
    if (bTest != abWrite[0]) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 7.2.       CHAR (1 )   .         0.
    sComment = StringConcatenate(sComment, "7.2.       CHAR.\n");
    Comment(sComment);
    char cTest = FileReadChar(hFileRead);
    sComment = StringConcatenate(sComment, "        : ", cTest, " (", acWrite[0], ")\n");
    Comment(sComment);
    if (cTest != acWrite[0]) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 7.3.       UCHAR (1 )   .         0.
    sComment = StringConcatenate(sComment, "7.3.       UCHAR.\n");
    Comment(sComment);
    uchar ucTest = FileReadUChar(hFileRead);
    sComment = StringConcatenate(sComment, "        : ", ucTest, " (", aucWrite[0], ")\n");
    Comment(sComment);
    if (ucTest != aucWrite[0]) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 7.4.       SHORT (2 )   .         0.
    sComment = StringConcatenate(sComment, "7.4.       SHORT.\n");
    Comment(sComment);
    short shTest = FileReadShort(hFileRead);
    sComment = StringConcatenate(sComment, "        : ", shTest, " (", ashWrite[0], ")\n");
    Comment(sComment);
    if (shTest != ashWrite[0]) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 7.5.       USHORT (2 )   .         0.
    sComment = StringConcatenate(sComment, "7.5.       USHORT.\n");
    Comment(sComment);
    ushort ushTest = FileReadUShort(hFileRead);
    sComment = StringConcatenate(sComment, "        : ", ushTest, " (", aushWrite[0], ")\n");
    Comment(sComment);
    if (ushTest != aushWrite[0]) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 7.6.       INT (4 )   .         0.
    sComment = StringConcatenate(sComment, "7.6.       INT.\n");
    Comment(sComment);
    int iTest = FileReadInt(hFileRead);
    sComment = StringConcatenate(sComment, "        : ", iTest, " (", aiWrite[0], ")\n");
    Comment(sComment);
    if (iTest != aiWrite[0]) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 7.7.       UINT (4 )   .         0.
    sComment = StringConcatenate(sComment, "7.7.       UINT.\n");
    Comment(sComment);
    uint uiTest = FileReadUInt(hFileRead);
    sComment = StringConcatenate(sComment, "        : ", uiTest, " (", auiWrite[0], ")\n");
    Comment(sComment);
    if (uiTest != auiWrite[0]) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 7.8.       INT64 (8 )   .         0.
    sComment = StringConcatenate(sComment, "7.8.       INT64.\n");
    Comment(sComment);
    long lTest = FileReadInt64(hFileRead);
    sComment = StringConcatenate(sComment, "        : ", lTest, " (", alWrite[0], ")\n");
    Comment(sComment);
    if (lTest != alWrite[0]) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 7.9.       UINT64 (8 )   .         0.
    sComment = StringConcatenate(sComment, "7.9.       UINT64.\n");
    Comment(sComment);
    ulong ulTest = FileReadUInt64(hFileRead);
    sComment = StringConcatenate(sComment, "        : ", ulTest, " (", aulWrite[0], ")\n");
    Comment(sComment);
    if (ulTest != aulWrite[0]) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 7.10.       FLOAT (4 )   .         0.
    sComment = StringConcatenate(sComment, "7.10.       FLOAT.\n");
    Comment(sComment);
    float fTest = FileReadFlt(hFileRead);
    sComment = StringConcatenate(sComment, "         : ", fTest, " (", afWrite[0], ")\n");
    Comment(sComment);
    if (fTest != afWrite[0]) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 7.11.       DOUBLE (8 )   .         0.
    sComment = StringConcatenate(sComment, "7.11.       DOUBLE.\n");
    Comment(sComment);
    double dTest = FileReadDbl(hFileRead);
    sComment = StringConcatenate(sComment, "         : ", dTest, " (", adWrite[0], ")\n");
    Comment(sComment);
    if (dTest != adWrite[0]) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 8.3.         UCHAR (1 )      .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "8.3.      ANSI-.\n");
    Comment(sComment);
    FileReadUCharArray(hFileRead, szReadAnsi, ArraySize(szReadAnsi), 0, ArraySize(szReadAnsi) - 1);
    sReadUnicode = CharArrayToString(szReadAnsi);
    sComment = StringConcatenate(sComment, "        : ", sReadUnicode, " (", sWriteUnicode, ")\n");
    Comment(sComment);
    if (sReadUnicode != sWriteUnicode) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //--------------------------------------------------------------------------------------------------------------------------------------------------------------------
    // 7.12.2.     UNICODE-     .         NULL.
    sComment = StringConcatenate(sComment, "7.12.2.     UNICODE-.\n");
    Comment(sComment);
    StringInit(sReadUnicode);
    sReadUnicode = FileReadStringW(hFileRead, StringLen(sWriteUnicode));
    sComment = StringConcatenate(sComment, "            : ", sReadUnicode, " (", sWriteUnicode, ")\n\n");
    Comment(sComment);
    if (sReadUnicode != sWriteUnicode) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    //xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
    // 8.     .
    //xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
    sComment = StringConcatenate(sComment, "8.      .\n");
    Comment(sComment);
    //===================================================================================================================================================================
    // 8.1.         BOOL (1 )      .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "8.1.         BOOL.\n");
    Comment(sComment);
    ulTest = FileReadBoolArray(hFileRead, abRead, ArraySize(abRead), 0, ArraySize(abRead));
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    for (i = 0; i < ArraySize(abRead) && i < ArraySize(abWrite); i++) if (abRead[i] != abWrite[i]) Alert(i, "    \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 8.2.         CHAR (1 )      .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "8.2.         CHAR.\n");
    Comment(sComment);
    ulTest = FileReadCharArray(hFileRead, acRead, ArraySize(acRead), 0, ArraySize(acRead));
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    for (i = 0; i < ArraySize(acRead) && i < ArraySize(acWrite); i++) if (acRead[i] != acWrite[i]) Alert(i, "    \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 8.3.         UCHAR (1 )      .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "8.3.         UCHAR.\n");
    Comment(sComment);
    ulTest = FileReadUCharArray(hFileRead, aucRead, ArraySize(aucRead), 0, ArraySize(aucRead));
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    for (i = 0; i < ArraySize(aucRead) && i < ArraySize(aucWrite); i++) if (aucRead[i] != aucWrite[i]) Alert(i, "    \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 8.4.         SHORT (2 )      .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "8.4.         SHORT.\n");
    Comment(sComment);
    ulTest = FileReadShortArray(hFileRead, ashRead, ArraySize(ashRead), 0, ArraySize(ashRead));
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    for (i = 0; i < ArraySize(ashRead) && i < ArraySize(ashWrite); i++) if (ashRead[i] != ashWrite[i]) Alert(i, "    \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 8.5.         USHORT (2 )      .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "8.5.         USHORT.\n");
    Comment(sComment);
    ulTest = FileReadUShortArray(hFileRead, aushRead, ArraySize(aushRead), 0, ArraySize(aushRead));
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    for (i = 0; i < ArraySize(aushRead) && i < ArraySize(aushWrite); i++) if (aushRead[i] != aushWrite[i]) Alert(i, "    \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 8.6.         INT (4 )      .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "8.6.         INT.\n");
    Comment(sComment);
    ulTest = FileReadIntArray(hFileRead, aiRead, ArraySize(aiRead), 0, ArraySize(aiRead));
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    for (i = 0; i < ArraySize(aiRead) && i < ArraySize(aiWrite); i++) if (aiRead[i] != aiWrite[i]) Alert(i, "    \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 8.7.         UINT (4 )      .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "8.7.         UINT.\n");
    Comment(sComment);
    ulTest = FileReadUIntArray(hFileRead, auiRead, ArraySize(auiRead), 0, ArraySize(auiRead));
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    for (i = 0; i < ArraySize(auiRead) && i < ArraySize(auiWrite); i++) if (auiRead[i] != auiWrite[i]) Alert(i, "    \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 8.8.         INT64 (8 )      .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "8.8.         INT64.\n");
    Comment(sComment);
    ulTest = FileReadLongArray(hFileRead, alRead, ArraySize(alRead), 0, ArraySize(alRead));
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    for (i = 0; i < ArraySize(alRead) && i < ArraySize(alWrite); i++) if (alRead[i] != alWrite[i]) Alert(i, "    \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 8.9.         UINT64 (8 )      .
    //              ULONG_MAX.
    sComment = StringConcatenate(sComment, "8.9.         UINT64.\n");
    Comment(sComment);
    ulTest = FileReadULongArray(hFileRead, aulRead, ArraySize(aulRead), 0, ArraySize(aulRead));
    sComment = StringConcatenate(sComment, "          : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    for (i = 0; i < ArraySize(aulRead) && i < ArraySize(aulWrite); i++) if (aulRead[i] != aulWrite[i]) Alert(i, "    \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 8.10.         FLOAT (4 )      .
    //               ULONG_MAX.
    sComment = StringConcatenate(sComment, "8.10.         FLOAT.\n");
    Comment(sComment);
    ulTest = FileReadFloatArray(hFileRead, afRead, ArraySize(afRead), 0, ArraySize(afRead));
    sComment = StringConcatenate(sComment, "           : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    for (i = 0; i < ArraySize(afRead) && i < ArraySize(afWrite); i++) if (afRead[i] != afWrite[i]) Alert(i, "    \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 8.11.         DOUBLE (8 )      .
    //               ULONG_MAX.
    sComment = StringConcatenate(sComment, "8.11.         DOUBLE.\n");
    Comment(sComment);
    ulTest = FileReadDoubleArray(hFileRead, adRead, ArraySize(adRead), 0, ArraySize(adRead));
    sComment = StringConcatenate(sComment, "           : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    for (i = 0; i < ArraySize(adRead) && i < ArraySize(adWrite); i++) if (adRead[i] != adWrite[i]) Alert(i, "    \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 8.12.2.      MQLSTRW-      .
    //                 ULONG_MAX.
    sComment = StringConcatenate(sComment, "8.12.2.     MQLSTRW-.\n");
    Comment(sComment);
    ulTest = FileReadStrArrayMW(hFileRead, asRead, ArraySize(asRead), 0, ArraySize(asRead));
    sComment = StringConcatenate(sComment, "           : ", ulTest, " (10)\n");
    Comment(sComment);
    if (ulTest != 10) Alert("  \"", __FILE__, "\"; : ", __LINE__);
    for (i = 0; i < ArraySize(asRead) && i < ArraySize(asWrite); i++) if (asRead[i] != asWrite[i]) Alert(i, "    \"", __FILE__, "\"; : ", __LINE__);
    //===================================================================================================================================================================
    // 2.2.     .
    sComment = StringConcatenate(sComment, "2.2.      (", hFileRead, ").\n\n");
    Comment(sComment);
    FileCloseHandle(hFileRead);
    //===================================================================================================================================================================
   }
 }
//